function [PosSemiVar,NegSemiVar,RatioSV,SD_RatioSV,RatioSVQuant]=SemiVarRatioBootstrap(XX,Quantili)

if nargin<2
    Quantili = [.05,.16,.84,.95]; 
end

PosSemiVar = sum((XX(XX>=mean(XX))-mean(XX)).^2)/(size(XX,1)-1);
NegSemiVar = sum((XX(XX<mean(XX))-mean(XX)).^2)/(size(XX,1)-1);
RatioSV = sqrt(NegSemiVar)/sqrt(PosSemiVar);

SizeVec= size(XX,1); MonteSize = 5000;  

for iipp=1:MonteSize
    Select = ceil(SizeVec*rand(SizeVec,1)); 
    XXi = XX(Select); 
    
    PosSemiVar_i = sum((XXi(XXi>=mean(XXi))-mean(XXi)).^2)/(size(XXi,1)-1);
    NegSemiVar_i = sum((XXi(XXi<mean(XXi))-mean(XXi)).^2)/(size(XXi,1)-1);
    VediRatioSV(iipp,1) = sqrt(NegSemiVar_i)/sqrt(PosSemiVar_i);
    
end

SD_RatioSV = std(VediRatioSV);
RatioSVQuant = quantile(VediRatioSV,Quantili); 
